<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "admission_student".
 *
 * @property int $id
 * @property int $identification_number
 * @property string $dateofbirth
 * @property int $id_admission_sex
 * @property int $id_admission_prefix
 * @property string $first_name
 * @property string $last_name
 * @property string $created_at
 * @property string $updated_time
 */
class AdmissionStudent extends \yii\db\ActiveRecord
{

    public $terms;
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'admission_student';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['identification_number', 'dateofbirth', 'id_admission_sex', 'id_admission_prefix', 'first_name', 'last_name'], 'required'],
            [['identification_number', 'id_admission_sex', 'id_admission_prefix'], 'integer'],
            [['dateofbirth', 'created_at', 'updated_time'], 'safe'],
            [['first_name', 'last_name'], 'string', 'max' => 255],
            ['terms', 'boolean'],
            ['terms', 'required', 'requiredValue' => true, 'message' => 'You must agree to the terms.'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'identification_number' => Yii::t('app', 'Identification Number'),
            'dateofbirth' => Yii::t('app', 'Dateofbirth'),
            'id_admission_sex' => Yii::t('app', 'Id Admission Sex'),
            'id_admission_prefix' => Yii::t('app', 'Id Admission Prefix'),
            'first_name' => Yii::t('app', 'First Name'),
            'last_name' => Yii::t('app', 'Last Name'),
            'created_at' => Yii::t('app', 'Created At'),
            'updated_time' => Yii::t('app', 'Updated Time'),
        ];
    }
}
