<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "admission_prefix".
 *
 * @property int $id
 * @property string $prefix_th_full
 * @property string $prefix_th_short
 * @property string $prefix_en
 */
class AdmissionPrefix extends \yii\db\ActiveRecord
{


    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'admission_prefix';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['prefix_th_full', 'prefix_th_short', 'prefix_en'], 'required'],
            [['prefix_th_full'], 'string', 'max' => 50],
            [['prefix_th_short'], 'string', 'max' => 4],
            [['prefix_en'], 'string', 'max' => 10],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'prefix_th_full' => Yii::t('app', 'Prefix Th Full'),
            'prefix_th_short' => Yii::t('app', 'Prefix Th Short'),
            'prefix_en' => Yii::t('app', 'Prefix En'),
        ];
    }

}
