<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "admission".
 *
 * @property int $id
 * @property int $code
 * @property string $title
 * @property string $description
 * @property int $id_year
 * @property int $id_admission_level
 * @property int $id_admission_type
 */
class Admission extends \yii\db\ActiveRecord
{


    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'admission';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['code', 'title', 'description', 'id_year', 'id_admission_level', 'id_admission_type'], 'required'],
            [['code', 'id_year', 'id_admission_level', 'id_admission_type'], 'integer'],
            [['description'], 'string'],
            [['title'], 'string', 'max' => 255],
            [['id_year', 'id_admission_level', 'id_admission_type'], 'unique', 'targetAttribute' => ['id_year', 'id_admission_level', 'id_admission_type']],
            [['code'], 'unique'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'code' => Yii::t('app', 'Code'),
            'title' => Yii::t('app', 'Title'),
            'description' => Yii::t('app', 'Description'),
            'id_year' => Yii::t('app', 'Id Year'),
            'id_admission_level' => Yii::t('app', 'Id Admission Level'),
            'id_admission_type' => Yii::t('app', 'Id Admission Type'),
        ];
    }

}
