<?php

/** @var yii\web\View $this */
/** @var yii\bootstrap5\ActiveForm $form */
/** @var \common\models\LoginForm $model */

use common\widgets\Alert;
use rmrevin\yii\fontawesome\FAB;
use yii\bootstrap5\ActiveForm;
use admission\models\LoginForm;
use yii\helpers\Html;

$this->title = \yii::t('app', 'Login');
?>
<div class="login-box">
    <div class="login-logo">
        <?= Html::encode($this->title) ?>
    </div>
    <!-- /.login-logo -->
    <div class="card">
        <div class="card-body login-card-body">
            <p class="login-box-msg"><?= Yii::t('app', 'Sign in to start your session') ?></p>

            <?php $form = ActiveForm::begin(); ?>
            <?= $form->field($model, 'identification_number') ?>
            <?= $form->field($model, 'dateofbirth')->passwordInput() ?>
            <!--begin::Row-->
            <div class="row">
                <!-- /.col -->
                <div class="col-4 col-offset-8">
                    <div class="d-grid gap-2">
                        <?= Html::submitButton(\yii::t('app', 'Login'), ['class' => 'btn btn-primary']) ?>

                    </div>
                </div>
                <!-- /.col -->
            </div>
            <!--end::Row-->
            <?php ActiveForm::end(); ?>
        </div>
        <!-- /.login-card-body -->
    </div>
</div>