<?php

use yii\helpers\Html;

$this->title = Yii::t('app', 'Error {code}', ['code' => $exception->statusCode]);
$this->params['hideTitle'] = true;
?>
<style>
    .error-page {
        margin-top: 50px;
    }

    .error-page .headline {
        font-size: 100px;
        font-weight: bold;
        text-align: center;
    }

    .error-page .error-content {
        margin-top: 20px;
        text-align: center;
    }
</style>
<div class="error-page">
    <h2 class="headline text-danger"><?= $exception->statusCode ?></h2>
    <div class="error-content">
        <h3><i class="fas fa-exclamation-triangle text-danger"></i> <?= $exception->getMessage() ?></h3>
        <p>
            <?= Yii::t('app', 'We will work on fixing that right away.') ?>
            <?= Yii::t('app', 'Meanwhile, you may {link}.', [
                'link' => Html::a(Yii::t('app', 'return to home'), ['/site/index']),
            ]) ?>
        </p>
    </div>
</div>