<?php

use yii\helpers\Html;
use yii\bootstrap5\ActiveForm;
use admission\models\Registration;
/* @var $this yii\web\View */
/* @var $model app\models\Registration */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="registration-form">

    <?php $form = ActiveForm::begin([
        'id' => 'registration-form',
        'options' => ['class' => 'form-horizontal'],
        'fieldConfig' => [
            'template' => "{label}\n{input}\n{error}",
            'labelOptions' => ['class' => 'control-label'],
        ],
    ]); ?>

    <?= $form->field($model, 'thai_id')->textInput([
        'maxlength' => 13,
        'placeholder' => '1234567890123',
        'class' => 'form-control',
        'id' => 'thai-id-input',
    ])->label('เลขบัตรประชาชน (Thai ID Number)') ?>

    <div class="form-group">
        <?= Html::submitButton('บันทึก (Save)', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>

<?php
$this->registerJs(<<<JS
// Thai ID validation function
function validateThaiID(id) {
    if (!/^[0-9]{13}$/.test(id)) {
        return false;
    }
    
    let sum = 0;
    for (let i = 0; i < 12; i++) {
        sum += parseInt(id.charAt(i)) * (13 - i);
    }
    
    let mod = sum % 11;
    let check = (11 - mod) % 10;
    
    return check == parseInt(id.charAt(12));
}

// Real-time validation
$('#thai-id-input').on('input', function() {
    let value = $(this).val();
    let formGroup = $(this).closest('.form-group');
    let helpBlock = formGroup.find('.help-block');
    
    // Remove existing validation messages
    helpBlock.remove();
    formGroup.removeClass('has-error has-success');
    
    if (value.length === 13) {
        if (validateThaiID(value)) {
            formGroup.addClass('has-success');
            formGroup.append('<div class="help-block help-block-success" style="color: green;">✓ เลขบัตรประชาชนถูกต้อง</div>');
        } else {
            formGroup.addClass('has-error');
            formGroup.append('<div class="help-block">เลขบัตรประชาชนไม่ถูกต้อง กรุณาตรวจสอบอีกครั้ง</div>');
        }
    } else if (value.length > 0) {
        formGroup.addClass('has-error');
        formGroup.append('<div class="help-block">กรุณากรอกเลขบัตรประชาชน 13 หัก</div>');
    }
});

// Prevent form submission if ID is invalid
$('#registration-form').on('beforeSubmit', function(e) {
    let thaiID = $('#thai-id-input').val();
    
    if (!validateThaiID(thaiID)) {
        alert('เลขบัตรประชาชนไม่ถูกต้อง กรุณาตรวจสอบอีกครั้ง');
        return false;
    }
    
    return true;
});

// Allow only numbers
$('#thai-id-input').on('keypress', function(e) {
    let charCode = (e.which) ? e.which : e.keyCode;
    if (charCode > 31 && (charCode < 48 || charCode > 57)) {
        e.preventDefault();
        return false;
    }
    return true;
});
JS
, \yii\web\View::POS_READY);
?>
