<?php

namespace admission\models;

use Yii;
use yii\base\Model;
use admission\models\User;

/**
 * Login form for admission students
 */
class LoginForm extends Model
{
    public $identification_number;
    public $dateofbirth;

    private $_student = false;

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['identification_number', 'dateofbirth'], 'required'],
            ['identification_number', 'string', 'length' => 13],
            ['dateofbirth', 'date', 'format' => 'php:Y-m-d'],
            ['identification_number', 'validateStudent'],
        ];
    }

    /**
     * Validates the student credentials
     */
    public function validateStudent($attribute, $params)
    {
        if (!$this->hasErrors()) {
            $student = $this->getStudent();
            if (!$student) {
                $this->addError($attribute, 'ไม่พบข้อมูลนักเรียน กรุณาตรวจสอบเลขบัตรประชาชนและวันเกิด');
            }
        }
    }

    /**
     * Logs in a user using the provided credentials
     * @return bool whether the user is logged in successfully
     */
    public function login()
    {
        if ($this->validate()) {
            $user = $this->getStudent();
            if ($user) {
                return Yii::$app->user->login($user); // 30 days
            }
        }
        return false;
    }

    /**
     * Finds user by identification_number and dateofbirth
     *
     * @return User|null
     */
    protected function getStudent()
    {
        if ($this->_student === false) {
            $this->_student = User::findOne([
                'identification_number' => $this->identification_number,
                'dateofbirth' => $this->dateofbirth,
            ]);
        }

        return $this->_student;
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'identification_number' => 'เลขบัตรประชาชน',
            'dateofbirth' => 'วันเกิด (ค.ศ.)',
            'rememberMe' => 'จดจำการเข้าสู่ระบบ',
        ];
    }
}
