<?php

namespace admission\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Admission;

/**
 * AdmissionSearch represents the model behind the search form of `common\models\Admission`.
 */
class AdmissionSearch extends Admission
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'id_year', 'id_admission_level', 'id_admission_type'], 'integer'],
            [['description', 'title'], 'string'],
            //[['created_at', 'updated_at'], 'safe'],
        ];
    }
    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     * @param string|null $formName Form name to be used into `->load()` method.
     *
     * @return ActiveDataProvider
     */
    public function search($params, $formName = null)
    {
        $query = Admission::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params, $formName);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'id_year' => $this->id_year,
            'id_admission_level' => $this->id_admission_level,
            'id_admission_type' => $this->id_admission_type,
           // 'created_at' => $this->created_at,
           // 'updated_at' => $this->updated_at,
        ]);

        $query->andFilterWhere(['like', 'description', $this->description])
            ->andFilterWhere(['like', 'title', $this->title]);

        return $dataProvider;
    }
}
